import express from "express";
import path from 'path';
import cors from "cors";
import dotenv from "dotenv";
import authRoutes from "./src/routes/authRoutes.js";

// import helmet from 'helmet';
// import rateLimit from 'express-rate-limit';


dotenv.config();

const app = express();

// const FRONTEND_ORIGIN = process.env.FRONTEND_ORIGIN || 'https://your-domain.com';

// app.use(cors({
//   origin: FRONTEND_ORIGIN,
//   methods: ['GET','POST','PUT','DELETE'],
//   credentials: true
// }));

app.use(cors());
app.use(express.json());

app.use("/api", authRoutes);

// app.get('/health', (req, res) => res.json({ ok: true, env: process.env.NODE_ENV || 'dev' }));

// serve frontend build (make sure you run `npm run build` in frontend and copy build to backend/public or adjust path)
// const __dirname = path.resolve();
// app.use(express.static(path.join(__dirname, 'frontend_build'))); // place the compiled React build here

// app.get('*', (req, res) => {
//   res.sendFile(path.join(__dirname, 'frontend_build', 'index.html'));
// });


// app.use(helmet());
// app.use(rateLimit({ windowMs: 60*1000, max: 120 }));


const PORT = process.env.PORT || 5000;
app.listen(PORT, () => console.log(`Server running on port ${PORT}`));
